import math

def load(list):
    print "Loading AI bindings"

    # binding format:
    # ( 'name of robot from .bot file', 'name of AI from script class',
    #       {'optional constructor parameter':value, 'another':value} )

    # constructor parameters:
    # nose - "front" of bot in radians (default 0)
    # invertible - can function upside-down (default False)
    # topspeed - speed in meters/second AI will attempt not to exceed (default 4.0)
    # throttle - maximum analog value AI will attempt not to exceed (default 100)
    # turnspeed - turning in radians/second AI will attempt not to exceed (default 2.5)
    # turn - maximum analog value AI will attempt not to exceed (default 60)
    # radius - bot radius to use for checking for hazards and walls (default 1.0)

    # 0 - Team B.O.C "Patrons of the Big Blue Flipper"
    list.append(("CW - Apogee III","Omni",{'radius':0.1,'topspeed':100,'throttle':100,'turn':60,'turnspeed':3.5,'weapons':(50,51)}))
    list.append(("HW - Avalon","Omni",{'nose':math.pi,'radius':0.1,'topspeed':100,'throttle':100,'turn':50,'turnspeed':3,'weapons':(69,70)}))
    list.append(("HW - Cicada II","Omni",{'range':500,'radius':1,'topspeed':100,'throttle':100,'turn':60,'turnspeed':4,'weapons':(96,147)}))
    list.append(("Wedge of Doom","Omni",{'nose':math.pi,'tactic':"Charge",'ThresholdSpeed':0.02,'reload':16,'radius':1,'topspeed':100,'throttle':100,'turn':50,'turnspeed':2,'weapons':(13,)}))
    list.append(("T-Minus","Flipper2",{'nose':math.pi,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':1.5,'weapons':(16,)}))
    list.append(("Techno Destructo","Flipper2",{'nose':math.pi,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':2,'weapons':(18,)}))

    # 2 - Team B.O.C 2 "Patrons of the Big Blue Flipper"
    list.append(("HW - Claymore","Omni",{'radius':0.1,'topspeed':100,'throttle':100,'turn':36,'turnspeed':3.5,'weapons':(99,100,111,112)}))
    list.append(("HW - Zealot III","Omni",{'invertible':True,'radius':0.3,'range':500,'topspeed':100,'throttle':100,'turn':60,'turnspeed':3,'weapons':(137,155,156)}))
    list.append(("HW - Singularity","Omni",{'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(199,200,202)}))
    list.append(("Robot X","Rammer",{'invertible':True,'nose':math.pi,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':2,'AimError':0.1}))
    list.append(("Beta","Judge",{'beta':-64000,'MotorID':1,'StartAngle':-math.pi*0.6,'reload':5,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':2.5,'weapons':(39,)}))
    list.append(("The Judge","Judge",{'MotorID':45,'StartAngle':-math.pi/2,'reload':8,'tactic':"Charge",'SightRange':2,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':2.5,'weapons':(46,)}))

    # 2 - Team Bullbusters"We're the ones running the rodeo"
    list.append(("Bullbot 2","Omni",{'nose':math.pi*1,'invertible':True,'radius':1,'topspeed':1000,'throttle':1300,'turn':60,'turnspeed':2.5,'weapons':(0,)}))
    list.append(("Cowbot","Omni",{'nose':math.pi*1,'invertible':True,'radius':1,'topspeed':1000,'throttle':1300,'turn':60,'turnspeed':2.5,'weapons':(0,)}))
    list.append(("Bullbot HW","Omni",{'nose':math.pi*1,'invertible':True,'radius':1,'topspeed':1000,'throttle':1300,'turn':60,'turnspeed':2.5,'weapons':(0,)}))
    list.append(("Bob","Omni",{'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':3,'weapons':(23,)}))
    list.append(("Billy-Bot","Omni",{'invertible':True,'range':50,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':1.5,'weapons':(15,16,24)}))
    list.append(("Alcoholic Stepfather","LaserGuidedV2",{'invertible':True,'delta':0.5,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':1.5,'weapons':(40,41,43)}))

    # 3 - Team Botbusters "Busting bots since 2017"
    list.append(("Thunderbolt 1.5","Omni",{'nose':math.pi,'range':99,'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(18,19)}))
    list.append(("12:01","Spinner",{'invertible':True,'nose':math.pi*1,'radius':0.2,'range':100,'topspeed':200,'throttle':200,'turn':60,'turnspeed':2.5,'weapons':(1,2,)}))
    list.append(("Ixnay","Omni",{'invertible':True,'nose':math.pi*1,'radius':0.1,'range':500,'topspeed':100,'throttle':130,'turn':60,'turnspeed':2.5,'weapons':(29,30,31,32,33)}))
    list.append(("Moros","SpinupOmni2",{'nose':math.pi,'MotorID':9,'JamTime':3,'radius':1,'range':99,'topspeed':100,'throttle':100,'turn':100,'turnspeed':2,'weapons':(17,)}))
    list.append(("BioHazard","Flipper2",{'EnemyMoveRadius':0.5,'SrimechInterval':3,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':2.5,'weapons':(33,)}))
    list.append(("Ronin","Omni",{'nose':math.pi,'invertible':True,'radius':1,'range':99,'topspeed':100,'throttle':100,'turn':100,'turnspeed':1,'weapons':(16,)}))

    # 4 - Team VVV "Veni, Vidi, Vici"
    list.append(("Knuckle Sandwich","Omni",{'invertible':True,'range':50,'radius':1,'topspeed':150,'throttle':150,'turn':50,'turnspeed':2.5,'weapons':(0,12,)}))
    list.append(("CW-Red Mist","Omni",{'invertible':True,'range':50,'radius':1,'topspeed':150,'throttle':150,'turn':50,'turnspeed':2.5,'weapons':(0,12,)}))
    list.append(("Snapdragon","Omni",{'invertible':False,'range':50,'radius':1,'topspeed':130,'throttle':130,'turn':50,'turnspeed':2.5,'weapons':(0,)}))
    list.append(("Cleprechaun","Omni",{'nose':math.pi,'radius':1,'range':99,'topspeed':5,'throttle':100,'turn':100,'turnspeed':1.5,'weapons':(17,)}))
    list.append(("El Diablo","Omni",{'invertible':True,'nose':math.pi,'range':99,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':2,'weapons':(6,7,16,17)}))
    list.append(("Shrederator","SpinupOmni2",{'MotorID':1,'JamTime':999,'nose':math.pi*1.6,'radius':1,'range':99,'topspeed':100,'throttle':100,'turn':100,'turnspeed':1.5,'weapons':(15,)}))

    # 5 - Alpha Robotics "Brought to you by Jazz."
    list.append(("AfterShock","Omni",{'invertible':True, 'car':True, 'range':500,'radius':1,'topspeed':135,'throttle':135,'turn':60,'turnspeed':2.5,'weapons':(0,)}))
    list.append(("Asphalt","Omni",{'invertible':False,'range':500,'radius':1,'topspeed':135,'throttle':135,'turn':60,'turnspeed':2.5,'weapons':(0,)}))
    list.append(("Avalanche","Omni",{'invertible':False,'range':500,'radius':1,'topspeed':135,'throttle':135,'turn':60,'turnspeed':2.5,'weapons':(0,)}))
    list.append(("Ziggo","SpinupOmni2",{'MotorID':7,'JamTime':999,'nose':math.pi,'radius':1,'range':99,'topspeed':100,'throttle':100,'turn':100,'turnspeed':2,'weapons':(11,)}))
    list.append(("Potter's Wheel","Omni",{'invertible':True,'nose':math.pi,'range':99,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':1,'weapons':(5,)}))
    list.append(("OverKill","Judge",{'reload':4,'StartAngle':math.pi/2,'MotorID':6,'invertible':True,'nose':math.pi,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':3.5,'weapons':(13,)}))

    # 6 - 0909090909090 "tfw"
    list.append(("Bullbot 1080p","Omni",{'nose':math.pi,'invertible':False,'range':500,'radius':1,'topspeed':135,'throttle':135,'turn':60,'turnspeed':2.5,'weapons':(0,)}))
    list.append(("SpED Demon","Omni",{'nose':math.pi*-.5,'invertible':False,'range':500,'radius':1,'topspeed':135,'throttle':135,'turn':60,'turnspeed':2.5,'weapons':(0,)}))
    list.append(("THE WTICHhh","Spinner",{'nose':math.pi,'invertible':True,'range':500,'radius':1,'topspeed':135,'throttle':135,'turn':60,'turnspeed':2.5,'weapons':(0,)}))
    list.append(("Whirl Wep","SwitchDirRam",{'invertible':True,'ThresholdSpeed':0.02,'BackUpTime':4,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':2.5,'weapons':(12,),'sweapons':(20,)}))
    list.append(("Slap Happy","FBS_2",{'fbs_range':8,'chase_time':15,'invertible':True,'nose':math.pi,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':1,'weapons':(2,10)}))
    list.append(("Panic Attack","Omni",{'nose':math.pi,'radius':1,'topspeed':6,'throttle':100,'turn':100,'turnspeed':1.5,'weapons':(7,)}))

    # 7 - Darvaza Demon Dominion "From the gas crater we rise!"
    list.append(("Anguish","Omni",{'nose':0,'invertible':True,'range':500,'radius':1,'topspeed':100,'throttle':100,'turn':70,'turnspeed':1.5,'weapons':(0,)}))
    list.append(("CW-Black metal","Spinner",{'nose':0,'invertible':True,'range':500,'radius':1,'topspeed':100,'throttle':100,'turn':70,'turnspeed':1.8,'weapons':(0,)}))
    list.append(("Shoulder devil","Omni",{'nose':0,'invertible':True,'range':500,'radius':1,'topspeed':100,'throttle':100,'turn':60,'turnspeed':1.5,'weapons':(0,)}))
    list.append(("Shish-Kabot","Omni",{'tactic':"Charge",'invertible':True,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':2.5,'weapons':(42,)}))
    list.append(("Vlad the Impaler","Omni",{'tactic':"Charge",'ThresholdSpeed':0.02,'reload':16,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':2.5,'weapons':(8,10)}))
    list.append(("Vladiator","Omni",{'nose':math.pi,'tactic':"Ram",'ThresholdSpeed':0.5,'invertible':True,'AimError':0.2,'reload':16,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':2.5,'weapons':(25,)}))

    # 8 -  Darvaza Demon Dominion 2 "From the gas crater we rise!"
    list.append(("Unethical","Omni",{'nose':0,'invertible':True,'range':500,'radius':1,'topspeed':100,'throttle':150,'turn':60,'turnspeed':1.5,'weapons':(0,)}))
    list.append(("Touch of evil","Omni",{'nose':0,'invertible':False,'range':500,'radius':1,'topspeed':100,'throttle':100,'turn':80,'turnspeed':2.0,'weapons':(0,)}))
    list.append(("White devil","Omni",{'nose':0,'invertible':False,'range':500,'radius':1,'topspeed':100,'throttle':100,'turn':80,'turnspeed':2.0,'weapons':(0,)}))
    list.append(("Backlash","DirectionalSpinner",{'range':99,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':1.5,'weapons':(11,)}))
    list.append(("Heavy Metal Noise","DirectionalSpinner",{'invertible':True,'range':99,'radius':1,'topspeed':100,'throttle':100,'turn':30,'turnspeed':2,'weapons':(16,17,18,19)}))
    list.append(("Nightmare","DirectionalSpinner",{'radius':1,'range':99,'topspeed':100,'throttle':100,'turn':100,'turnspeed':1,'weapons':(19,22,23)}))

    # 9 - Lilly's Bedroom Robotics "Lets drink mayonnaise in Valencia."
    list.append(("Ice Pick","Omni",{'nose':math.pi*1,'radius':0.3,'topspeed':200,'throttle':200,'turn':30,'turnspeed':4,'weapons':(46,)}))
    list.append(("4-bar connection","Omni",{'nose':math.pi*1,'radius':0.3,'topspeed':200,'throttle':200,'turn':30,'turnspeed':3.5,'weapons':(91,92,95,96)}))
    list.append(("Bodyhammer","Pusher",{'nose':0,'radius':0.3,'invertible':True,'topspeed':200,'throttle':200,'turn':45,'turnspeed':3.5,}))
    list.append(("YU812","SpinupOmni2",{'MotorID':1,'radius':1,'range':99,'topspeed':100,'throttle':100,'turn':100,'turnspeed':2.5,'weapons':(16,17,18)}))
    list.append(("MechaVore","EcoOmni",{'range':99,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':3.5,'weapons':(15,)}))
    list.append(("Minion","SwitchDirRam",{'nose':math.pi,'range':99,'ThresholdSpeed':0.02,'BackUpTime':4,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':2.5,'weapons':(42,),'sweapons':(10,)}))

    # 10 - Hammer Down  "We fight in the arena so you could live in the front seat"
    list.append(("Shibu Yenu","Flipper2",{'invertible':False,'range':50,'radius':1,'topspeed':100,'throttle':100,'turn':80,'turnspeed':2,'UseSrimech':0,'EnemyMoveRadius':1,'EnemyMoveTime':3,'cooldown':4,'PrioritizeFlipper':0,'NoChassisTime':1,'SrimechInterval':1,'weapons':(18,19,20,21,22,23,24,25,26,)}))
    list.append(("Willow","Flipper2",{'invertible':False,'range':50,'radius':1,'topspeed':100,'throttle':100,'turn':80,'turnspeed':2,'UseSrimech':0,'EnemyMoveRadius':1,'EnemyMoveTime':3,'cooldown':4,'PrioritizeFlipper':0,'NoChassisTime':1,'SrimechInterval':1,'weapons':(18,19,20,21,22,23,24,25,26,)}))
    list.append(("Wireless Builder","InvertOmni",{'invertible':False,'range':50,'radius':1,'topspeed':150,'throttle':150,'turn':65,'turnspeed':1.9,'weapons':(43,44,),'sweapons':(42,)}))
    list.append(("Hunter","TopPusher",{'invertible':True,'tactic':"Charge",'ThresholdSpeed':0.02,'BackUpTime':4,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':2.5}))
    list.append(("Complete Control","Flipper2",{'UseSrimech':1,'EnemyMoveRadius':0.5,'nose':math.pi,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':2.5,'weapons':(14,)}))
    list.append(("Tazbot","LaserGuidedTH",{'nose':math.pi,'radius':1,'servorange':4,'servonose':1,'delta':0.75,'servospeed':100,'topspeed':100,'mayFire':True,'throttle':100,'turn':100,'turnspeed':1.5,'weapons':(24,)}))

    # 11 - Hammer Down 2  "We fight in the arena so you could live in the front seat"
    list.append(("Founding Titan","InvertOmni",{'invertible':False,'range':50,'radius':1,'topspeed':150,'throttle':150,'turn':80,'turnspeed':2,'weapons':(62,63,64,65,),'sweapons':(84,85,)}))
    list.append(("Rap God","Omni",{'invertible':True,'range':50,'radius':1,'topspeed':150,'throttle':150,'turn':75,'turnspeed':1.9,'weapons':(53,54,55,)}))
    list.append(("Chamomile","Drum",{'invertible':True,'radius':1,'range':50,'reload':40,'ThresholdSpeed':0.04,'BackUpTime':0.4,'topspeed':140,'throttle':140,'turn':90,'turnspeed':2.2,'weapons':(15,16,17,18,19,20,21,22,)}))
    list.append(("Apollyon","TopPusher",{'invertible':True,'tactic':"Charge",'ThresholdSpeed':0.02,'BackUpTime':4,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':2.5}))
    list.append(("That Darn Dustpan!","Judge",{'MotorID':13,'StartAngle':math.pi/2,'Tolerance':math.pi/2,'reload':32,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':2.5,'weapons':(18,)}))
    list.append(("The KillDozer","Rammer",{'invertible':True,'nose':math.pi,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':1}))

    # 12 - Gym Rats"Getting Busy on a Friday Night"
    list.append(("Open Wormhole","Omni",{'invertible':True,'range':50,'radius':1,'topspeed':150,'throttle':150,'turn':75,'turnspeed':1.9,'weapons':(53,54,55,)}))
    list.append(("Golden Ratio","Omni",{'nose':0,'tactic':"Charge",'ThresholdSpeed':0.02,'reload':16,'radius':1,'topspeed':100,'throttle':100,'turn':50,'turnspeed':2,'weapons':(13,)}))
    list.append(("Hurricane","Omni",{'tactic':"Ram",'ThresholdSpeed':0.02,'reload':16,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':2.5,'weapons':(8,10)}))
    list.append(("Whack!","Frenzy",{'radius':1,'topspeed':4,'throttle':100,'turn':100,'turnspeed':2,'weapons':(11,)}))
    list.append(("Hworf","Omni",{'invertible':True,'range':99,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':1,'weapons':(5,7)}))
    list.append(("frenZy","Judge",{'MotorID':5,'StartAngle':math.pi*0.6,'nose':math.pi/2,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':3.5,'weapons':(7,8)}))

    # 13 - Gym Rats 2"Getting Busy on a Friday Night"
    list.append(("CW-Thunder Bird","InvertOmni",{'invertible':False,'range':50,'radius':1,'topspeed':150,'throttle':150,'turn':80,'turnspeed':2,'weapons':(62,63,64,65,),'sweapons':(84,85,)}))
    list.append(("CW-Wrecks","Omni",{'nose':0,'invertible':True,'range':50,'radius':1,'topspeed':150,'throttle':150,'turn':60,'turnspeed':1.6,'weapons':(36,37,)}))
    list.append(("Chubby Lad","Flipper2",{'nose':0,'invertible':False,'range':50,'radius':1,'topspeed':150,'throttle':150,'turn':130,'turnspeed':3.2,'UseSrimech':0,'EnemyMoveRadius':1,'EnemyMoveTime':2,'cooldown':2,'PrioritizeFlipper':0,'NoChassisTime':1,'SrimechInterval':1,'weapons':(10,11,12,13,14,15,16,17,)}))
    list.append(("Vertigo","VertSpinner",{'radius':1,'range':99,'topspeed':100,'throttle':100,'turn':100,'turnspeed':3,'weapons':(22,23),'sweapons':(0,)}))
    list.append(("Tornado Mer","SpinupOmni2",{'MotorID':1,'nose':math.pi/2,'range':99,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':2.5,'weapons':(6,7,8)}))
    list.append(("M.O.E.","DirectionalSpinner",{'invertible':True,'nose':math.pi,'range':99,'radius':.5,'turn':30,'turnspeed':2.5,'weapons':(12,13,25,26,27,28,29,30)}))

    # 14 - Angry Penguin Robotics "Don't Chat if you don't want to get the flip-flap"
    list.append(("Logic Bomb","Omni",{'nose':math.pi,'invertible':True,'range':500,'radius':1,'topspeed':135,'throttle':135,'turn':60,'turnspeed':2.5,'weapons':(0,)}))
    list.append(("CW-Malware","Omni",{'nose':math.pi*.5,'invertible':True,'range':500,'radius':1,'topspeed':135,'throttle':135,'turn':60,'turnspeed':2.5,'weapons':(0,)}))
    list.append(("Data Breach V1.5","Omni",{'nose':math.pi,'invertible':False,'range':500,'radius':1,'topspeed':135,'throttle':135,'turn':60,'turnspeed':2.5,'weapons':(0,)}))
    list.append(("Flip Test Dummy","Rammer",{'invertible':True,'radius':2,'topspeed':100,'throttle':120,'turn':60,'turnspeed':4}))
    list.append(("The Stuff of Champions","Omni",{'radius':0.1,'range':99,'topspeed':100,'throttle':130,'turn':60,'turnspeed':4,'weapons':(16,17)}))
    list.append(("WreckTangle 2","Rammer",{'radius':0.1,'topspeed':100,'throttle':130,'turn':60,'turnspeed':4}))

    # 15- Florida Man Robotics "Building robots and doing meth since 2016"
    list.append(("Crime Scene","Omni",{'nose':math.pi*1,'radius':0.1,'range':100,'topspeed':100,'throttle':100,'turn':60,'turnspeed':3.5,'weapons':(0,)}))
    list.append(("The GAMETECHMODS Experience","Omni",{'invertible':True,'nose':math.pi*1,'radius':0.1,'range':100,'topspeed':100,'throttle':100,'turn':60,'turnspeed':3.5,'weapons':(0,)}))
    list.append(("Turbocharger","Flipper",{'nose':0,'radius':0.1,'range':100,'topspeed':100,'throttle':100,'turn':60,'turnspeed':3.5,'weapons':(0,)}))
    list.append(("Outgunned","LaserGuidedTH",{'nose':math.pi*1.5,'radius':1,'servorange':4,'servonose':1,'delta':0.75,'servospeed':100,'topspeed':100,'mayFire':True,'throttle':100,'turn':60,'turnspeed':3.5,'weapons':(0,)}))
    list.append(("Rust In Peace","Judge",{'radius':1,'MotorID':3,'StartAngle':+math.pi/2,'reload':7,'nose':math.pi*1,'range':99,'invertible':False,'topspeed':100,'throttle':130,'turn':60,'turnspeed':3,'weapons':(0,)}))
    list.append(("Outgunned","LaserGuidedTH",{'nose':math.pi*1.5,'radius':1,'servorange':4,'servonose':1,'delta':0.75,'servospeed':100,'topspeed':100,'mayFire':True,'throttle':100,'turn':60,'turnspeed':3.5,'weapons':(0,)}))

    #16- BildschirmStuff "Bild that makes some stuffs :P"
    list.append(("Hu Tao","Flipper2",{'cooldown':10,'EnemyMoveRadius':1.2,'UseSrimech':1,'SrimechInterval':2.2,'radius':0.2,'topspeed':150,'throttle':150,'turn':75,'turnspeed':3.1,'weapons':(0,)}))
    list.append(("Caress","Flipper2",{'invertible':False,"UseSrimech":1,'reload':6,'range':99,'car':True,'radius':0.1,'topspeed':1000,'throttle':1000,'turn':100,'turnspeed':1.9,'weapons': ( 0, )}))
    list.append(("Greetox 1.1","Arrowhead",{'invertible':True,'car':True,'range':99,'radius':0.1,'topspeed':1000,'throttle':1000,'turn':100,'turnspeed':1.9,'weapons': ( 0, )}))
    list.append(("Corra 2","Arrowhead",{'range':99,'radius':0.1,'car':True,'topspeed':1000,'throttle':1000,'turn':100,'turnspeed':2.5,'weapons': ( 0, )}))
    list.append(("Kanna","Drum",{'invertible':True,'range':99,'radius':0.1,'topspeed':1000,'throttle':100,'turn':20,'turnspeed':2,'weapons': (0,)}))
    list.append(("SmolRoka","Drum",{'invertible':True,'range':99,'radius':0.1,'topspeed':1000,'throttle':100,'turn':20,'turnspeed':2,'weapons': (0,)}))

    # 17- Neon Raptor "Brought to you by Zorua"
    list.append(("Battle-Raptor 5","Omni",{'invertible':False,'car':True, 'nose':math.pi*.5,'radius':0.1,'range':100,'topspeed':100,'throttle':100,'turn':50,'turnspeed':2,'weapons':(0,)}))
    list.append(("Fenrir","Omni",{'nose':math.pi*-.5,'invertible':True,'car':True,'radius':0.1,'range':100,'topspeed':100,'throttle':100,'turn':50,'turnspeed':2.5,'weapons':(0,)}))
    list.append(("Terminal Velocity","Omni",{'invertible':False,'nose':math.pi,'radius':0.1,'range':100,'topspeed':100,'throttle':100,'turn':50,'turnspeed':2,'weapons':(0,)}))
    list.append(("All Terrain Train","BiDirRam",{'invertible':True,'range':50,'radius':1,'topspeed':170,'throttle':170,'turn':85,'turnspeed':2.1,'weapons':(102,103,),'sweapons':(104,105,)}))
    list.append(("Hypno-Disc","Omni",{'nose':math.pi,'invertible':False,'range':50,'radius':1,'topspeed':130,'throttle':130,'turn':95,'turnspeed':2.4,'tactic':"Charge",'ThresholdSpeed':0.1,'SightRange':2,'BackUpTime':99,'AimError':0,'weapons':(17,18,)}))
    list.append(("Typhoon 2","SpinupOmni2",{'nose':-math.pi/2,'invertible':False,'range':50,'radius':1,'topspeed':130,'throttle':130,'turn':85,'turnspeed':2.1,'MotorID':14,'Motor2ID':-1,'TargetRPM':200,'DisplayRPM':0,'JamTime':999,'weapons':(18,19,20,21,)}))

    # 18 - The Candy Store "We might be heaven & we might be hell!"
    list.append(("PuriN 20XX","VertSpinner",{'nose':0,'invertible':False,'range':100,'radius':1,'topspeed':100,'throttle':100,'turn':100,'turnspeed':2.5,'TrollDanceZone':1,'weapons':(1,2,),'sweapons':(1,2)}))
    list.append(("DAISY_BELL","Omni",{'nose':0,'invertible':False,'range':99,'radius':0.1,'topspeed':1000,'throttle':900,'turn':50,'turnspeed':2,'weapons':(12,13,14,15,)}))
    list.append(("throops!","Flipper2",{'invertible':False,'range':50,'radius':1,'topspeed':420,'throttle':420,'turn':60,'turnspeed':3.5,'EnemyMoveRadius':1,'EnemyMoveTime':2,'cooldown':2,'PrioritizeFlipper':0,'NoChassisTime':0.5,'SrimechInterval':0.75,'weapons':(1,2,3,4,5,6,7,8,)}))
    list.append(("Black Rainbows","Omni",{'invertible':False,'range':100,'radius':1,'topspeed':140,'throttle':140,'turn':60,'turnspeed':2.5,'weapons':(0,)}))
    list.append(("Greed II","Omni",{'range':50,'radius':1,'topspeed':140,'throttle':140,'turn':60,'turnspeed':2.5,'weapons':(0,)}))
    list.append(("superposition","Omni",{'invertible':False,'range':100,'radius':1,'topspeed':140,'throttle':140,'turn':70,'turnspeed':3,'weapons':(0,)}))

    # 19 - Robot Arena Reincarnated "From the forgotten graves and rusting junk we rise again!"
    list.append(("Gammaraze III","Omni",{'invertible':True,'range':50,'radius':1,'topspeed':150,'throttle':150,'turn':75,'turnspeed':1.9,'weapons':(41,42,43,44,45,46,47,48,)}))
    list.append(("Topknot II","LaserGuidedTH",{'nose':math.pi/2,'invertible':False,'range':50,'radius':1,'topspeed':130,'throttle':130,'turn':70,'turnspeed':1.8,'servospeed':30,'delta':0.2,'servorange':3.5,'servonose':1,'weapons':(62,)}))
    list.append(("ScootOrDie","Flipper2",{'invertible':False,'range':50,'radius':1,'topspeed':130,'throttle':130,'turn':75,'turnspeed':1.9,'UseSrimech':1,'EnemyMoveRadius':1,'EnemyMoveTime':5,'cooldown':4,'PrioritizeFlipper':1,'NoChassisTime':1,'SrimechInterval':1,'weapons':(38,)}))
    list.append(("Aquarius 2","Omni",{'invertible':True,'range':50,'radius':1,'topspeed':140,'throttle':140,'turn':70,'turnspeed':1.8,'weapons':(23,)}))
    list.append(("Pon2n","Omni",{'invertible':False,'range':50,'radius':1,'topspeed':140,'throttle':140,'turn':85,'turnspeed':2.1,'weapons':(39,40,41,42,45,46,)}))
    list.append(("Triclops v2.0","Judge",{'beta':-64000,'MotorID':22,'StartAngle':-math.pi*0.6,'reload':5,'radius':1,'topspeed':150,'throttle':150,'turn':90,'turnspeed':2.3,'weapons':(38,)}))

    # 20 - Arthrobotics "Be warned... these bugs swat back."
    list.append(("AW-Nanowhirl","SpinupOmni2",{'nose':math.pi,'invertible':False,'range':50,'radius':1,'topspeed':140,'throttle':140,'turn':95,'turnspeed':2.3,'MotorID':1,'Motor2ID':-1,'TargetRPM':250,'DisplayRPM':0,'JamTime':999,'weapons':(9,)}))
    list.append(("AW-Terminus","Omni",{'invertible':True,'range':30,'radius':1,'topspeed':140,'throttle':140,'turn':80,'turnspeed':2,'weapons':(12,)}))
    list.append(("BW-Microwhirl","SpinupOmni2",{'nose':math.pi,'invertible':False,'range':50,'radius':1,'topspeed':140,'throttle':140,'turn':95,'turnspeed':2.3,'MotorID':2,'Motor2ID':-1,'TargetRPM':350,'DisplayRPM':0,'JamTime':999,'weapons':(5,)}))
    list.append(("BW-True Love","Drum",{'invertible':True,'radius':1,'range':50,'reload':40,'ThresholdSpeed':0.04,'BackUpTime':0.4,'topspeed':150,'throttle':150,'turn':90,'turnspeed':2.3,'weapons':(8,9,10,11,)}))
    list.append(("BW-Peer Pressure","Flipper2",{'invertible':False,'range':50,'radius':1,'topspeed':140,'throttle':140,'turn':85,'turnspeed':2.1,'UseSrimech':0,'EnemyMoveRadius':1,'EnemyMoveTime':2,'cooldown':2,'PrioritizeFlipper':0,'NoChassisTime':1,'SrimechInterval':1,'weapons':(10,11,12,19,20,)}))
    list.append(("BW-Robokilase","Omni",{'invertible':True,'range':50,'radius':1,'topspeed':150,'throttle':150,'turn':75,'turnspeed':1.9,'tactic':"Ram",'ThresholdSpeed':2,'SightRange':4,'BackUpTime':99,'AimError':0,'weapons':(21,22,23,)}))
